Attribute VB_Name = "Custom"
Option Explicit

''' Object for sending messages to WorkBench
Public Mess As QFWB.Messenger

''' Global QuickField variables
Public QF As QuickField.Application
Public Prb As QuickField.Problem

''' Variable contains all input parameters
Public theParameters As QFWB.Parameters

''' Variable contains project, problem and model name
Public theName As String

''' Terminating flag
Private Cancel As Boolean


''' Modify basic geometrical model
Public Sub ModifyModel()
    ''' Catch unknown server errors
    On Error GoTo ServerError

    Mess.State "Modifying model", Cancel
    If Cancel Then Exit Sub

    ''' QuickField Model Object
    Dim Mdl As QuickField.Model
    Set Mdl = Prb.Model
    Set QF = Prb.Application

    ''' Local variables for all input parameters
    Dim airGap As Double
    airGap = theParameters("Air Gap").Value
    Dim keeperHeight As Double
    keeperHeight = theParameters("Keeper Height").Value
    Dim keeperWidth As Double
    keeperWidth = theParameters("Keeper Width").Value
    Dim magnetHeight As Double
    magnetHeight = theParameters("Magnet Height").Value
    Dim magnetWidth As Double
    magnetWidth = theParameters("Magnet Width").Value
    Dim yokeHeight As Double
    yokeHeight = theParameters("Yoke Height").Value
    Dim yokeWidth As Double
    yokeWidth = theParameters("Yoke Width").Value

    ''' ----------------------------------------
    ''' TODO: Modify QuickField model (Mdl) here
    Dim shp As QuickField.ShapeRange
    Dim yBase As Double
    Dim xBase As Double
    
    With Mdl.Shapes
        .RemoveMesh
        .Delete
    
        Set shp = .AddEdge(QF.PointXY(-yokeWidth / 2, 0), QF.PointXY(yokeWidth / 2, 0))
        .AddEdge QF.PointXY(yokeWidth / 2, 0), QF.PointXY(yokeWidth / 2, yokeHeight)
        .AddEdge QF.PointXY(yokeWidth / 2, yokeHeight), QF.PointXY(-yokeWidth / 2, yokeHeight)
        .AddEdge QF.PointXY(-yokeWidth / 2, yokeHeight), QF.PointXY(-yokeWidth / 2, 0)
        shp.Left.Label = "Steel"
            ' Right Magnet
        Set shp = .AddEdge(QF.PointXY(yokeWidth / 2, yokeHeight), _
                           QF.PointXY(yokeWidth / 2, yokeHeight + magnetHeight))
        .AddEdge QF.PointXY(yokeWidth / 2, yokeHeight + magnetHeight), _
                 QF.PointXY(yokeWidth / 2 - magnetWidth, yokeHeight + magnetHeight)
        .AddEdge QF.PointXY(yokeWidth / 2 - magnetWidth, yokeHeight + magnetHeight), _
                 QF.PointXY(yokeWidth / 2 - magnetWidth, yokeHeight)
        shp.Left.Label = "ALNICO down"
            ' Left Magnet
        Set shp = .AddEdge(QF.PointXY(-yokeWidth / 2, yokeHeight), _
                           QF.PointXY(-yokeWidth / 2, yokeHeight + magnetHeight))
        .AddEdge QF.PointXY(-yokeWidth / 2, yokeHeight + magnetHeight), _
                 QF.PointXY(-yokeWidth / 2 + magnetWidth, yokeHeight + magnetHeight)
        .AddEdge QF.PointXY(-yokeWidth / 2 + magnetWidth, yokeHeight + magnetHeight), _
                 QF.PointXY(-yokeWidth / 2 + magnetWidth, yokeHeight)
        shp.Right.Label = "ALNICO up"
            ' Steel Keeper
        yBase = yokeHeight + magnetHeight + airGap
        Set shp = .AddEdge(QF.PointXY(-keeperWidth / 2, yBase), _
                            QF.PointXY(keeperWidth / 2, yBase))
        .AddEdge QF.PointXY(keeperWidth / 2, yBase), _
                 QF.PointXY(keeperWidth / 2, yBase + keeperHeight)
        .AddEdge QF.PointXY(keeperWidth / 2, yBase + keeperHeight), _
                 QF.PointXY(-keeperWidth / 2, yBase + keeperHeight)
        .AddEdge QF.PointXY(-keeperWidth / 2, yBase + keeperHeight), _
                 QF.PointXY(-keeperWidth / 2, yBase)
        shp.Left.Label = "Steel Keeper"
            ' Surrounding air
        yBase = yokeHeight + magnetHeight + airGap + keeperHeight
        xBase = (yokeWidth + keeperWidth) * 1.5
        Set shp = .AddEdge(QF.PointXY(-xBase, -yBase), QF.PointXY(xBase, -yBase))
        .AddEdge QF.PointXY(xBase, -yBase), QF.PointXY(xBase, 2 * yBase)
        .AddEdge QF.PointXY(xBase, 2 * yBase), QF.PointXY(-xBase, 2 * yBase)
        .AddEdge QF.PointXY(-xBase, 2 * yBase), QF.PointXY(-xBase, -yBase)
        shp.Left.Label = "Air"
        .Boundary(qfOuterOnly).Label = "Zero"
        
            ' Set Spacing
        Dim spCore As Double        ' Average spacing inside magnets and aramature
        Dim spSurround As Double    ' Average spacing in surroundng air
        
        spCore = fMax(yokeHeight + magnetHeight + airGap + keeperHeight, _
                       (keeperWidth + yokeWidth) / 2)
        spCore = spCore / 8
        spSurround = (xBase + yBase) / 6
        
        '.LabeledAs(Block:="Steel Keeper").Spacing = sp
        '.LabeledAs(Block:="Steel").Spacing = sp
        .LabeledAs(Block:="ALNICO up").Spacing = spCore
        .LabeledAs(Block:="ALNICO down").Spacing = spCore
        .LabeledAs(Edge:="Zero").Spacing = spSurround
    End With
    ''' ----------------------------------------
    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Model modifying caused QuickField error.", Cancel
End Sub


''' Set label data (has call for each 'Physical' input parameter)
Public Sub SetLabel(ParamName As String)
    ''' Catch unknown server errors
    On Error GoTo ServerError

    Mess.State "Editing " & ParamName & " data.", Cancel
    If Cancel Then Exit Sub

    ''' Labels collection
    Dim Lbs As QuickField.Labels
    ''' Editing label
    Dim Lab As QuickField.Label
    ''' Editing label content
    Dim LabCnt As QuickField.LabelBlockMS

    Select Case ParamName
    Case "Coercive Force"
        ''' ----------------------------------------
        Dim Hc As Double
        Hc = theParameters("Coercive Force").Value

        ''' TODO: Edit QuickField label corresponding 'Coercive Force' parameter
        '''     Probable code for Block label:
        '''     - uncomment code below
        '''     - for Vertex and Edges use 'qfVertex' or 'qfEdge' constants
        '''     - replace 'Air' with your QuickField label name
        '''
        ' Set Lbs = Prb.DataDoc.Labels(qfBlock)  'Select block labels collection
        ' Set Lab = Lbs("Air")  'Get label
        ' Set LabCnt = Lab.Content  'Get label content

        ''' TODO: Edit here the LabCnt properties
        Set Lbs = Prb.DataDoc.Labels(qfBlock)  'Select block labels collection
        Set Lab = Lbs("ALNICO up")  'Get label
        Set LabCnt = Lab.Content  'Get label content
        LabCnt.Coercive = QF.PointRA(Hc, 3.1415926 / 2)
        Lab.Content = LabCnt  'Update label content
        
        Set Lbs = Prb.DataDoc.Labels(qfBlock)  'Select block labels collection
        Set Lab = Lbs("ALNICO down")  'Get label
        Set LabCnt = Lab.Content  'Get label content
        LabCnt.Coercive = QF.PointRA(Hc, -3.1415926 / 2)
        Lab.Content = LabCnt  'Update label content
        ''' ----------------------------------------

    End Select

    ''' Save modified label data
    Prb.DataDoc.Save

    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Label editing caused QuickField error.", Cancel
End Sub


''' Build contour for exploring integral output parameters
Public Function BuildContour() As QuickField.Contour
    ''' Catch unknown server errors
    On Error GoTo ServerError

    Mess.State "Building contour", Cancel
    If Cancel Then Exit Function

    ''' QuickField result window object
    Dim Wnd As QuickField.FieldWindow
    ''' Contour object
    Dim Cnt As QuickField.Contour

    ''' Get FieldWindow object
    Set Wnd = Prb.Result.Windows(1)
    ''' Get new Contour object
    Set Cnt = Wnd.Contour

    ''' ----------------------------------------
    ''' TODO: Build Contour here
    
    ''' Local variables for all input parameters
    Dim airGap As Double
    airGap = theParameters("Air Gap").Value
    Dim keeperHeight As Double
    keeperHeight = theParameters("Keeper Height").Value
    Dim keeperWidth As Double
    keeperWidth = theParameters("Keeper Width").Value
    Dim magnetHeight As Double
    magnetHeight = theParameters("Magnet Height").Value
    Dim magnetWidth As Double
    magnetWidth = theParameters("Magnet Width").Value
    Dim yokeHeight As Double
    yokeHeight = theParameters("Yoke Height").Value
    Dim yokeWidth As Double
    yokeWidth = theParameters("Yoke Width").Value

    With Cnt
        .AddLineTo QF.PointXY(-keeperWidth / 2 - magnetWidth, yokeHeight + magnetHeight + airGap / 2)
        .AddLineTo QF.PointXY(keeperWidth / 2 + magnetWidth, yokeHeight + magnetHeight + airGap / 2)
        .AddLineTo QF.PointXY(keeperWidth / 2 + magnetWidth, yokeHeight + magnetHeight + airGap + keeperHeight * 1.5)
        .AddLineTo QF.PointXY(-keeperWidth / 2 - magnetWidth, yokeHeight + magnetHeight + airGap + keeperHeight * 1.5)
        .AddLineTo QF.PointXY(-keeperWidth / 2 - magnetWidth, yokeHeight + magnetHeight + airGap / 2)
    End With
    ''' ----------------------------------------

    Set BuildContour = Cnt
    Exit Function

ServerError:
    Mess.Error wbCritical Or wbServerError, "Contour building caused QuickField error.", Cancel
End Function


''' Calculate point output parameters
Public Sub Calculations(Pt As QFWB.ResultPoint)
    ''' QuickField result document object
    Dim Res As QuickField.Result

    ''' Get Result document
    Set Res = Prb.Result

    ''' Local variables for all input postprocessor parameters

    ''' ----------------------------------------
    ''' TODO:
    '''   - if you have point output parameters:
    '''       Replace 'PointXY(0, 0)' by a Point you need accordingly input parameters
    '''   - if you have no point output parameters:
    '''       Remove these code lines
    Dim yokeHeight As Double
    yokeHeight = theParameters("Yoke Height").Value
    
    Dim Locals As QuickField.FieldPoint
    Set Locals = Res.GetLocalValues(PointXY(0, 0))
    ''' ----------------------------------------

    ''' ----------------------------------------
    ''' TODO:
    '''   - if you have no integral output parameters:
    '''       Remove these code lines
    Dim Cnt As QuickField.Contour
    Set Cnt = BuildContour
    ''' ----------------------------------------

    Mess.State "Getting result values", Cancel
    If Cancel Then Exit Sub

    ''' ----------------------------------------
    ''' Start getting output parameter values
    'Flux density
    Pt.Value(1) = Locals.Grad.R
    'Mechanical torque
    Pt.Value(2) = Res.GetIntegral(qfInt_MaxwellForce, Cnt).Abs
    ''' End getting output parameter values
    ''' ----------------------------------------

    Mess.State "Ready", Cancel
End Sub

Private Function fMin(f1 As Double, f2 As Double) As Double
    If f1 >= f2 Then
        fMin = f2
    Else
        fMin = f1
    End If
End Function

Private Function fMax(f1 As Double, f2 As Double) As Double
    If f1 >= f2 Then
        fMax = f1
    Else
        fMax = f2
    End If
End Function




